/**
 * Блок авторизации пользователя
 *
 * @type {}
 */
const authorization = {
    loginLink: '.user .menu__item[href^="//passport.yandex-team.ru/auth"]',
    loginInput: 'input[name="login"]',
    passwordInput: 'input[name="passwd"]',
    logoutLink: '.user .menu__item[href^="//passport.yandex-team.ru/passport?mode=logout&yu="]',
    logoutApproveLink: '.link[href^="/passport?origin=passport_profile&mode=logout&yu="]',
    submitButton: '.domik-submit'
};

/**
 * Блок с изображением пользователя на сервисе
 *
 * @type {}
 */
const user = {
    block: '.user',
    avatar: '.user .user__pic'
};

/**
 * Блок с логотипом сервиса
 *
 * @type {}
 */
const service = {
    logo: '.head__logo',
    label: '.head__service-label'
};

/**
 * Блок саджеста в шапке сервиса
 *
 * @type {}
 */
const suggest = {
    input: '.head__left input',
    searchButton: '.head__left .app_trigger_search',
    clearButton: '.head__left .input .input__clear',
    popup: '.head__left .input .menu',
    suggestItem: '.menu__group [data-suggest-value="%"]'
};

/**
 * Заглушка при загрузке сервиса
 *
 * @type {}
 */
const loader = {
    main: '.loader'
};

/**
 * Базовые блоки.
 * Содержит элементы, которые есть на любой странице сервиса.
 */
module.exports = {
    authorization,
    user,
    service,
    suggest,
    loader
};
