/* eslint max-statements: [1, 12] */

/**
 * @description Example of the SYNC helper.
 *              Simply replaces %TEST% placeholders with some string.
 */
SANDBOX.registerViewHelper('replacePlaceholders', rawDataToProcess => {
    return $.Deferred().resolve(rawDataToProcess.replace('%TEST%', 'INSERTED WITH HELPER')); // eslint-disable-line
});

/**
 * @description Example of the ASYNC helper.
 *              Simply replaces %TEST% placeholders with some string.
 */
SANDBOX.registerViewHelper('replacePlaceholdersAsync', rawDataToProcess => {
    return $.Deferred(def => { // eslint-disable-line
        rawDataToProcess = rawDataToProcess.replace('%TEST%', 'INSERTED WITH HELPER AFTER 3 SECONDS DELAY');

        // Emulating async request or some other not linear operation
        setTimeout(() => {
            def.resolve(rawDataToProcess);
        }, 3000);
    });
});

SANDBOX.registerViewHelper('processJSONAsync', someJSON => {
    return $.Deferred(def => { // eslint-disable-line
        // Emulating async request or some other not linear operation
        setTimeout(() => {
            def.resolve(someJSON);
        }, 3000);
    });
});

/** = DEMO HELPERS ================================================================= END ==== */

/** = REAL HELPERS =============================================================== START ==== */

SANDBOX.registerValidationHelper('check_int', dataToValidate => {
    const result = (new RegExp('^-?[0-9]+$')).test(String(dataToValidate.value));

    return result ?
        $.Deferred().resolve() : // eslint-disable-line
        $.Deferred().reject({    // eslint-disable-line
            success: false,
            message: 'That field should be INTEGER'
        });
});

SANDBOX.registerValidationHelper('check_positive_int', dataToValidate => {
    const result = (new RegExp('^[0-9]+$')).test(String(dataToValidate.value));

    return result ?
        $.Deferred().resolve() :  // eslint-disable-line
        $.Deferred().reject({     // eslint-disable-line
            success: false,
            message: 'That field should be POSITIVE INTEGER'
        });
});

SANDBOX.registerValidationHelper('check_dummy', dataToValidate => {
    return sendValidationRequest(_.extend(dataToValidate, {
        validator: 'check_dummy'
    }));
});

SANDBOX.registerValidationHelper('check_string', dataToValidate => {
    return sendValidationRequest(_.extend(dataToValidate, {
        validator: 'check_string'
    }));
});

SANDBOX.registerValidationHelper('check_svn_url', dataToValidate => {
    return sendValidationRequest(_.extend(dataToValidate, {
        validator: 'check_svn_url'
    }));
});

SANDBOX.registerValidationHelper('check_for_empty_files', dataToValidate => {
    return sendValidationRequest(_.extend(dataToValidate, {
        validator: 'check_for_empty_files'
    }));
});

/**
 * @param {Object} data
 * @param {String} data.name      - Name of the field
 * @param {String} data.value     - Value to validate
 * @param {String} data.task_id   - ID of the task which prop will be validated
 * @param {String} data.validator - Name of the validator function
 *
 * @returns {JQueryDeferred}
 */
function sendValidationRequest(data) {
    const isValid = $.Deferred(); // eslint-disable-line

    $.ajax({
        url: '/api/v1.0/validate/field_legacy',
        type: 'GET',
        data
    })
        .done(response => {
            if (response && response.status && response.status === 'ok') {
                isValid.resolve();
            }

            isValid.reject({ msg: (response && response.reason) ? response.reason : 'Field is not valid' });
        })
        .fail(() => {
            isValid.reject({ msg: 'Error during request to a server.' });
        });

    return isValid;
}

/**
 * @param {Object}   data
 * @param {Object[]} data.fields    - Set of values to validate
 * @param {String}   data.task_id   - ID of the task which prop will be validated
 *
 * @returns {JQueryDeferred}
 */
SANDBOX.registerValidationHelper('unified_helper', data => {
    const isValid = $.Deferred(); // eslint-disable-line

    if (data && data.parent && data.fields) {
        $.ajax({
            url: (data.parent.getValidateURL()),
            type: 'POST',
            data: JSON.stringify(data.fields),
            dataType: 'json',
            contentType: 'application/json'
        })
            .done(response => {
                const withErrors = _.filter(response, responseItem => {
                    return (responseItem.status === 'WARNING' || responseItem.status === 'ERROR');
                });

                if (withErrors.length > 0) {
                    const message = withErrors.length ?
                        'Some custom fields are not valid: <br/>' + withErrors.map(item => {
                            return (item.name ? (item.name + ': ') : '') + item.message;
                        }).join('<br/>') :
                        'Some custom fields are not valid';

                    isValid.reject({ msg: message, results: withErrors });
                } else {
                    isValid.resolve();
                }
            })
            .fail(() => {
                isValid.reject({
                    msg: 'Error has occured during validation request.'
                });
            });
    } else {
        isValid.reject({ msg: 'Not enough data passed to the validator.' });
    }

    return isValid;
});

SANDBOX.registerValidationHelper('json_helper', data => {
    const isValid = $.Deferred(); // eslint-disable-line

    if (data && data.parent && data.fields) {
        const withErrors = data.fields.map(field => {
            const format = (field.hasError &&
                field.hasError.format &&
                field.hasError.format.toUpperCase()) || 'JSON';

            return field.hasError ? {
                name: field.name,
                message: `You should write valid ${format}`
            } : false;
        }).filter(Boolean);

        if (withErrors.length > 0) {
            const message = withErrors.length ?
                'Some custom fields are not valid: <br/>' + withErrors.map(item => {
                    return (item.name ? (item.name + ': ') : '') + item.message;
                }).join('<br/>') :
                'Some custom fields are not valid';

            isValid.reject({ msg: message, results: withErrors });
        } else {
            isValid.resolve();
        }
    } else {
        isValid.reject({ msg: 'Not enough data passed to the validator.' });
    }

    return isValid;
});
