import axios from 'axios';

import {
    FETCH_ADMIN_GROUPS,
    FETCH_ADMIN_GROUPS_SUCCESS,
    ALERT_PUSH,
    PUSH_GROUP,
    PUSH_GROUP_SUCCESS,
    REMOVE_GROUP,
    REMOVE_GROUP_SUCCESS
} from '../actions';

const errorHandler = function (dispatch) {
    return function (error) {
        return dispatch({
            type: ALERT_PUSH,
            payload: {
                type: 'error',
                message: error.reason || error.message
            }
        });
    };
};

const fetchGroupsList = function () {
    const request = axios.get('/api/v1.0/group', {
        params: {
            limit: 100500
        }
    });

    return function (dispatch) {
        dispatch({ type: FETCH_ADMIN_GROUPS });

        return request
            .then(response => {
                return dispatch({
                    type: FETCH_ADMIN_GROUPS_SUCCESS,
                    payload: response.data
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

const pushGroup = function (payload) {
    return function (dispatch) {
        dispatch({ type: PUSH_GROUP, payload });

        return axios.post(`/api/v1.0/group`, payload)
            .then(response => {
                return dispatch({
                    type: PUSH_GROUP_SUCCESS,
                    payload: response.data
                });
            }, errorHandler(dispatch));
    };
};

const updateGroup = function (payload) {
    return function (dispatch) {
        dispatch({ type: PUSH_GROUP, payload });

        return axios.put(`/api/v1.0/group/${payload.name}`, payload)
            .then(() => {
                return dispatch({
                    type: PUSH_GROUP_SUCCESS,
                    payload
                });
            }, errorHandler(dispatch));
    };
};

const removeGroup = function (payload) {
    return function (dispatch) {
        dispatch({ type: REMOVE_GROUP, payload });

        return axios.delete(`/api/v1.0/group/${payload.name}`, payload)
            .then(() => {
                return dispatch({
                    type: REMOVE_GROUP_SUCCESS,
                    payload
                });
            }, errorHandler(dispatch));
    };
};

module.exports = {
    fetchGroupsList,
    pushGroup,
    updateGroup,
    removeGroup
};
