import axios from 'axios';

import actions from '../actions';

const fetchGroupsList = function () {
    const request = axios.get('/api/v1.0/suggest/group');

    return function (dispatch) {
        dispatch({ type: actions.FETCH_GROUPS });

        return request
            .then(response => {
                return dispatch({
                    type: actions.FETCH_GROUPS_SUCCESS,
                    payload: response.data
                });
            }, error => {
                return dispatch({
                    type: actions.FETCH_GROUPS_FAILURE,
                    payload: error
                });
            });
    };
};

module.exports = {
    fetchGroupsList
};
