import axios from 'axios';

import {
    ADD_TAG,
    REMOVE_TAG,
    REMOVE_TAG_SUCCESS,
    APPLY_TAGS,
    ALERT_PUSH
} from '../actions';

const add = function (params) {
    if (!params.id || !params.tags) {
        return;
    }

    const url = `/api/v1.0/task/${params.id}/tags`;
    const request = axios.post(url, params.tags, {
        headers: {
            'Content-Type': 'text/plain;charset=UTF-8'
        }
    });

    return function (dispatch) {
        dispatch({ type: ADD_TAG });

        return request
            .then(() => {
                return dispatch({
                    type: APPLY_TAGS,
                    payload: {
                        id: String(params.id),
                        tags: params.tags
                    }
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

const remove = function (params) {
    if (!params.id || !params.tag) {
        return;
    }

    const url = `/api/v1.0/task/${params.id}/tags/${params.tag}`;
    const request = axios.delete(url);

    return function (dispatch) {
        dispatch({ type: REMOVE_TAG });

        return request
            .then(response => {
                return dispatch({
                    type: REMOVE_TAG_SUCCESS,
                    payload: {
                        id: String(params.id),
                        tag: params.tag,
                        data: response.data
                    }
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

const applyTags = function (params) {
    return {
        type: APPLY_TAGS,
        payload: {
            id: String(params.id),
            tags: params.tags
        }
    };
};

module.exports = {
    add,
    remove,
    applyTags
};
