/* eslint max-statements: [1, 15] */
/* eslint complexity: [1, 11] */

import axios from 'axios';

import actions from '../actions';

const errorHandler = function (dispatch) {
    return function (error) {
        return dispatch({
            type: actions.ALERT_PUSH,
            payload: {
                type: 'error',
                message: error.reason || error.message
            }
        });
    };
};

const fetchTaskList = function (params) {
    params = Object.assign(
        { limit: 100500, children: true },
        params,
        {
            offset: (params && params.page !== 1 && (params.page - 1) * params.limit) ?
                ((params.page - 1) * params.limit) :
                0
        }
    );

    const request = axios.get('/api/v1.0/task', { params });

    return function (dispatch) {
        dispatch({ type: actions.FETCH_TASKS });

        return request
            .then(response => {
                return dispatch({
                    type: actions.FETCH_TASKS_SUCCESS,
                    payload: {
                        data: response.data
                    }
                });
            }, errorHandler(dispatch));
    };
};

function fetchTaskReport(params) {
    if (!params.taskId || !params.name || !params.url) {
        return;
    }

    const request = axios.get(params.url);

    return function (dispatch) {
        dispatch({
            type: actions.FETCH_TASK_REPORT,
            payload: {
                taskId: String(params.taskId),
                name: params.name,
                url: params.url
            }
        });

        return request
            .then(response => {
                return dispatch({
                    type: actions.FETCH_TASK_REPORT_SUCCESS,
                    payload: {
                        data: response.data,
                        taskId: String(params.taskId),
                        name: params.name,
                        url: params.url
                    }
                });
            }, errorHandler(dispatch));
    };
}

module.exports = {
    fetchTaskList,
    fetchTaskReport
};
