import axios from 'axios';

import {
    FETCH_USER_GROUPS,
    FETCH_USER_GROUPS_SUCCESS,
    FETCH_USER_PREFERENCES,
    FETCH_USER_PREFERENCES_SUCCESS,
    ALERT_PUSH,
    SET_CONFIG
} from '../actions';

const setConfig = function (data) {
    return {
        type: SET_CONFIG,
        payload: {
            namespace: data.namespace,
            key: data.key,
            value: data.value
        }
    };
};

const fetchGroupsList = function () {
    const request = axios.get('/api/v1.0/user/current/groups');

    return function (dispatch) {
        dispatch({ type: FETCH_USER_GROUPS });

        return request
            .then(response => {
                return dispatch({
                    type: FETCH_USER_GROUPS_SUCCESS,
                    payload: response.data
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

const fetchPreferences = function () {
    const request = axios.get('/api/v1.0/user/current/preferences/prefs');

    return function (dispatch) {
        dispatch({ type: FETCH_USER_PREFERENCES });

        return request
            .then(response => {
                return dispatch({
                    type: FETCH_USER_PREFERENCES_SUCCESS,
                    payload: response.data
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

const putPreferences = function (data) {
    const request = axios.put('/api/v1.0/user/current/preferences/prefs', data);

    return function (dispatch) {
        dispatch({ type: FETCH_USER_PREFERENCES });

        return request
            .then(() => {
                return dispatch({
                    type: FETCH_USER_PREFERENCES_SUCCESS,
                    payload: data
                });
            }, error => {
                return dispatch({
                    type: ALERT_PUSH,
                    payload: {
                        type: 'error',
                        message: error.reason || error.message
                    }
                });
            });
    };
};

module.exports = {
    fetchGroupsList,
    fetchPreferences,
    putPreferences,
    setConfig
};
