// Noinspection BadExpressionStatementJS
/* eslint max-statements: [1, 21] */

const UserMixin = require('./mixin/User');
const TasksMixin = require('./mixin/Tasks');
const ShardsMixin = require('./mixin/Shards');
const TaskPropsMixin = require('./mixin/TaskProperties');
const PagePropsMixin = require('./mixin/PageProps');
const TaskMixin = require('./mixin/Task');
const ClientsMixin = require('./mixin/Clients');
const ReleasesMixin = require('./mixin/Releases');
const ResourceMixin = require('./mixin/Resource');
const ResourcesMixin = require('./mixin/Resources');
const UserGroupsMixin = require('./mixin/UserGroups');
const VaultsMixin = require('./mixin/Vaults');
const SemaphoresMixin = require('./mixin/Semaphores');
const ServiceThreads = require('./mixin/ServiceThreads');
const SchedulersMixin = require('./mixin/Schedulers');
const SchedulerMixin = require('./mixin/Scheduler');
const SandboxNotificationsMixin = require('./mixin/SandboxNotifications');
const ServiceNotificationsMixin = require('./mixin/ServiceNotifications');

/**
 * @class CoreApplication
 */
const CoreApplication = Backbone.Model.mixin(
    UserMixin,
    UserGroupsMixin,
    TasksMixin,
    TaskPropsMixin,
    PagePropsMixin,
    TaskMixin,
    ClientsMixin,
    ReleasesMixin,
    ResourceMixin,
    ResourcesMixin,
    VaultsMixin,
    SemaphoresMixin,
    ServiceThreads,
    ShardsMixin,
    SchedulersMixin,
    SchedulerMixin,
    ServiceNotificationsMixin,
    SandboxNotificationsMixin
).extend({});

module.exports = CoreApplication;
