const LAYOUT_CONFIG = {
    OAUTH: {
        type: 'OAUTH',
        layout: require('../../views/layouts/content/OAuthContentLayout'),
        isAutoupateEnabled: false,
        hasMenu: false
    },
    ERROR: {
        type: 'ERROR',
        layout: require('../../views/layouts/content/ErrorPageLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    GROUP: {
        type: 'GROUP',
        layout: require('../../views/layouts/content/SingleGroupContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    CLIENTS: {
        type: 'CLIENTS',
        layout: require('../../views/layouts/content/ClientsContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    DB_STATE: {
        type: 'DB_STATE',
        layout: require('../../views/layouts/content/DBStateContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    TASK_LIST: {
        type: 'TASK_LIST',
        layout: require('../../views/layouts/content/TaskListContentLayout'),
        controls: require('../../views/controlSection/ControlSectionLayout'),
        isAutoupdateEnabled: true,
        hasMenu: true
    },
    STAT_TASKS: {
        type: 'STAT_TASKS',
        layout: require('../../views/layouts/content/StatisticsContentLayout'),
        resourceMethod: 'statistics',
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    STAT_XMLRPC: {
        type: 'STAT_XMLRPC',
        layout: require('../../views/layouts/content/XmlrpcStatisticsContentLayout'),
        resourceMethod: 'statistics',
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    STAT_REST: {
        type: 'STAT_REST',
        layout: require('../../views/layouts/content/RestStatisticsContentLayout'),
        resourceMethod: 'statistics',
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    RELEASE_LIST: {
        type: 'RELEASE_LIST',
        layout: require('../../views/layouts/content/ReleaseListContentLayout'),
        controls: require('../../views/controlSection/releasesList/ReleasesListControlSection'),
        isAutoupdateEnabled: true,
        hasMenu: true
    },
    MANAGE_VAULTS: {
        type: 'MANAGE_VAULTS',
        layout: require('../../views/layouts/content/ManageVaultsContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    MANAGE_SEMAPHORES: {
        type: 'MANAGE_SEMAPHORES',
        layout: require('../../views/layouts/content/ManageSemaphoresContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    SEMAPHORE: {
        type: 'SEMAPHORE',
        layout: require('../../views/layouts/content/SingleSemaphoreContentLayout'),
        isAutoupateEnabled: true,
        hasMenu: false
    },
    MANAGE_GROUPS: {
        type: 'MANAGE_GROUPS',
        layout: require('../../views/layouts/content/ManageGroupsContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: false
    },
    RESOURCE_LIST: {
        type: 'RESOURCE_LIST',
        layout: require('../../views/layouts/content/ResourceListContentLayout'),
        controls: require('../../views/controlSection/resourcesList/ResourcesListControlSection'),
        isAutoupdateEnabled: true,
        hasMenu: true
    },
    SINGLE_RESOURCE: {
        type: 'SINGLE_RESOURCE',
        layout: require('../../views/layouts/content/SingleResourceContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: true
    },
    CREATE_RESOURCE: {
        type: 'CREATE_RESOURCE',
        layout: require('../../views/layouts/content/CreateResourceContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: true
    },
    SINGLE_TASK: {
        type: 'SINGLE_TASK',
        layout: require('../../views/layouts/content/SingleTaskContentLayout'),
        isAutoupdateEnabled: true,
        hasMenu: true,
        forceContentAutoupdateDisabledForAction: [
            'hosts'
        ],
        pushNotificationFor: [
            'SUCCESS',
            'FAILURE',
            'DELETED',
            'RELEASED',
            'STOPPED',
            'NO_RES',
            'EXCEPTION',
            'TIMEOUT',
            'EXPIRED'
        ]
    },
    SINGLE_TASK_CREATE: {
        type: 'SINGLE_TASK_CREATE',
        layout: require('../../views/layouts/content/CreateTaskContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: true
    },
    SERV_THREADS: {
        type: 'SERV_THREADS',
        layout: require('../../views/layouts/content/ServiceThreadsContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    TASK_TYPES: {
        type: 'TASK_TYPES',
        layout: require('../../views/layouts/content/ManageTaskTypesContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    SCHEDULERS_LIST: {
        type: 'SCHEDULERS_LIST',
        layout: require('../../views/layouts/content/SchedulersListContentLayout'),
        controls: require('../../views/controlSection/schedulersList/SchedulersListControlSection'),
        isAutoupdateEnabled: false,
        hasMenu: true
    },
    SINGLE_SCHEDULER: {
        type: 'SINGLE_SCHEDULER',
        layout: require('../../views/layouts/content/SingleSchedulerContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: true
    },
    SANDBOX_NOTIFICATIONS_LIST: {
        type: 'SANDBOX_NOTIFICATIONS_LIST',
        layout: require('../../views/layouts/content/SandboxNotificationsContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    SERVICE_NOTIFICATIONS_LIST: {
        type: 'SERVICE_NOTIFICATIONS_LIST',
        layout: require('../../views/layouts/content/ServiceNotificationsContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    HOST_QUEUE: {
        type: 'HOST_QUEUE',
        layout: require('../../views/layouts/content/HostQueueContentLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    },
    PREFERENCES: {
        type: 'PREFERENCES',
        layout: require('../../views/layouts/content/PreferencesPageLayout'),
        isAutoupdateEnabled: false,
        hasMenu: false
    }
};

module.exports = {

    getPageConfig(pageType, extendedProps) {
        if (LAYOUT_CONFIG[pageType]) {
            return _.extend({}, LAYOUT_CONFIG[pageType], extendedProps);
        }
        return LAYOUT_CONFIG.ERROR;
    }
};
