/* eslint max-statements: [1, 50] */

const render = Marionette.Renderer.render;
const cookie = require('bemmy/src/blocks/component/cookie');

Marionette.Renderer.render = function () {
    return render.apply(this, arguments).toString();
};

moment.locale('en', {
    relativeTime: {
        future: 'in %s',
        past: '%s ago',
        s: '%ds',
        m: '1m',
        mm: '%dm',
        h: '1h',
        hh: '%dh',
        d: '1d',
        dd: '%dd',
        M: '1mo',
        MM: '%dmo',
        y: '1y',
        yy: '%dy'
    }
});

// .includes() instead .indexOf()
require('string.prototype.includes');
require('array-includes').shim();

// Init infrastructure
require('yasap-cache');
require('./security');
require('./retry');
require('./authUpdate');
require('./helpers/utils/autoNavigate');
require('./helpers/utils/infoHeadersParser');

// Init staff-card
require('./helpers/utils/staffCards');

// Jquery validate extensions
require('./helpers/utils/jquery-validate-extend');

// Bemmy
require('bemmy/blocks/user');
require('./bemmy/blocks/user'); // Head-menu redefenition
require('bemmy/blocks/service');
require('bemmy/blocks/menu');
require('bemmy/blocks/button');
require('./bemmy/blocks/button'); // Here is redefined RadioButtonView to avoid performance issues
require('bemmy/blocks/input');
require('bemmy/blocks/textarea');
require('bemmy/blocks/select');
require('bemmy/blocks/radiogroup');
require('bemmy/blocks/check');
require('bemmy/blocks/datepicker');
require('./bemmy/blocks/datepicker');
require('bemmy/blocks/spinner');
require('bemmy/blocks/modal');
require('bemmy/blocks/popup');

// Make your life a little easy
require('./views/index');
require('./constants');

window.numeral = require('numeral');
window.numeral.language('sandbox', {
    delimiters: {
        thousands: ' ',
        decimal: '.'
    },
    abbreviations: {
        thousand: 'k',
        million: 'm',
        billion: 'b',
        trillion: 't'
    },
    ordinal(number) {
        return number === 1 ? 'st' : 'th';
    },
    currency: {
        symbol: '$'
    }
});

window.numeral.language('sandbox');

// Configure controller
require('./router');

// Let's party start
require('./app').start();
require('./helpers/bootstrap');

// Common page loader
require('./views/components/PageLoader');

Backbone.history.start({ pushState: true });

// Provide API
window.SANDBOX = require('./helpers/api/sandboxAPI');

if (!window.develop) {
    const Raven = require('raven-js');

    Raven.config('https://95a1bdfa9f98471caa9016b906c5971f@unity.qloud.yandex-team.ru/4', {
        release: window.uiVersion
    }).install();
}

if (cookie.get('catSpinnerPreference') === '1') {
    $('.loader__in').addClass('loader__cat');
}
$('.loader__in').addClass('loaded');

if (window.location.protocol === 'http:' && window.location.host === 'sandbox.yandex-team.ru') {
    window.location.protocol = 'https:';
}
