/* eslint camelcase: 0 */

import { includes } from 'lodash';

const app = require('../app');
const TaskResourcesCollection = require('../collection/TaskResourcesCollection');

/**
 * @class CustomFieldsCollection
 * @extends Backbone.Collection
 */
const CustomFieldsCollection = Backbone.Collection.extend({

    model: require('../model/CustomFieldModel'),

    /**
     * @param {TaskModel} task
     * @returns {JQueryPromise}
     */
    validateFields(task) {
        const self = this;

        const fieldsData = self.reduce((result, customField) => {
            const modifiers = customField.get('modifiers');

            if (customField.get('type') !== 'block' && customField.isAvailable()) {
                if (
                    !modifiers ||
                    (modifiers && !modifiers.format) ||
                    (modifiers && modifiers.format && !includes(['json', 'yaml'], modifiers && modifiers.format && modifiers.format.toLowerCase()))
                ) {
                    result.unified_helper.push({
                        name: customField.get('name'),
                        value: customField.get('value'),
                        hasError: customField.get('hasError')
                    });
                } else if (modifiers && modifiers.format && includes(['json', 'yaml'], modifiers.format.toLowerCase())) {
                    result.json_helper.push({
                        name: customField.get('name'),
                        value: customField.get('value'),
                        hasError: customField.get('hasError')
                    });
                }
            }

            return result;
        }, {
            unified_helper: [],
            json_helper: []
        });

        const helpers = {
            unified_helper: app.getHelperManager().getValidationHelper('unified_helper'),
            json_helper: app.getHelperManager().getValidationHelper('json_helper')
        };

        return $.when.apply($, [ // eslint-disable-line
            helpers.unified_helper({
                parent: task,
                fields: fieldsData.unified_helper
            }),
            helpers.json_helper({
                parent: task,
                fields: fieldsData.json_helper
            })]);
    },

    fetchResourcesDescription() {
        const self = this;
        const resourceIds = this.collectResourceIds();

        if (resourceIds.length > 0) {
            const resources = new TaskResourcesCollection([], { id: resourceIds.join(',') });

            resources.update().done(() => {
                self.mapResourceMeta(resources);
            });
        }
    },

    collectResourceIds() {
        return this
            .filter(field => {
                return (['resource', 'container'].indexOf(field.get('type')) !== -1);
            })
            .map(field => {
                return field.get('value');
            });
    },

    mapResourceMeta(resources) {
        this.forEach(customField => {
            if (['resource', 'container'].indexOf(customField.get('type')) !== -1) {
                const storedID = String(customField.get('value'));
                const descriptions = {};
                const links = {};
                const skynetIds = {};

                storedID.split(',').forEach(id => {
                    id = parseInt(id, 10);

                    resources.forEach(resource => {
                        if (resource.get('id') === id) {
                            descriptions[id] = resource.get('description');
                            links[id] = resource.get('http');
                            skynetIds[id] = resource.get('skynet_id');
                        }
                    });
                });

                customField.set({
                    resource_description: descriptions,
                    resource_links: links,
                    resource_skynet: skynetIds
                });
            }
        });
    }
});

module.exports = CustomFieldsCollection;
