// eslint-disable-next-line no-unused-vars
const error = require('../error');
// eslint-disable-next-line no-unused-vars
const cookie = require('bemmy/src/blocks/component/cookie');
const BasicCollection = require('./BasicCollection');
// eslint-disable-next-line no-unused-vars
const DateTimeIntervalModel = require('./../model/DateTimeIntervalModel');
const EnqueuedTasksFilterModel = require('../model/filter/EnqueuedTasksFilterModel');

/**
 * @class EnqueuedTasksCollection
 * @extends BasicCollection
 * @extends Backbone.Events
 */
const EnqueuedTasksCollection = BasicCollection.extend({

    url: '/api/v1.0/service/q',
    model: require('../model/service/EnqueuedTaskModel'),

    metricKey: 'TASKS-LOADED',

    options: {
        page: 1,
        total: 1,
        lastSelected: null,
        lastShifted: false,
        filterParams: {
            serializeAsQuery() {
                return this.client;
            }
        },
        pageCapacity: 20,
        selectedItems: []
    },

    initialize(models, options) {
        this.mapQueryOptions(options);
    },

    /**
     * @returns {FilterModel}
     */
    getFilterParams() {
        return this.options.filterParams;
    },

    /**
     * @param {Object} updateOptions Set of options collection will be updated with.
     *
     * @return {JQueryDeferred}
     */
    update(updateOptions) {
        const self = this;

        if (this.isUpdating) {
            this.isNeedUpdate = true;

            return false;
        }

        updateOptions = updateOptions || this.getPagingOptions();

        this.isUpdating = true;
        this.trigger('update:start');

        return this
            .fetch({
                data: _.extend(
                    this.getFetchParams(updateOptions),
                    this.getFilterParams().serializeAsQuery()
                )
            })
            .always(() => {
                self.isUpdating = false;

                if (self.isNeedUpdate) {
                    self.isNeedUpdate = false;
                    self.update();
                } else {
                    self.trigger('update:complete');
                }
            });
    },

    mapFilterQueryOptions(options) {
        this.options.filterParams = new EnqueuedTasksFilterModel(options);
    }

});

module.exports = EnqueuedTasksCollection;
