const BasicCollection = require('./BasicCollection');
const BasicFilterModel = require('../model/filter/BasicFilterModel');

/**
 * @class ManagedTaskTypesCollection
 * @extends BasicCollection
 *
 * @property {object}              options
 * @property {TaskTypesCollection} options.sourceCollection Source on which client pagination
 *                                                          and sorting will be done
 */
const ManagedTaskTypesCollection = BasicCollection.extend({

    model: require('./../model/resources/TaskTypeModel'),

    setFilterParams(filterParams) {
        if (filterParams instanceof BasicFilterModel) {
            const params = filterParams.getFilterParams();

            this.options.sourceCollection.updateFilter(type => {
                /* eslint max-statements: [1, 11] */
                /* eslint complexity: [1, 11] */

                if (params.owner && params.type) {
                    if (type.get('owners').includes(params.owner) && type.get('type') === params.type) {
                        return true;
                    }
                    return false;
                }

                if (!params.owner && !params.type) {
                    return true;
                }

                if (params.owner && type.get('owners').includes(params.owner)) {
                    return true;
                }

                if (params.type && type.get('type') === params.type) {
                    return true;
                }

                return false;
            });

            this.options.filterParams = filterParams;
            this.options.pageCapacity = 20;
            this.options.total = this.options.sourceCollection.length;

            this.setPage(1);

            this.trigger('change:filterparams');
        }
    },

    update(updateOptions) {
        const fetchParams = this.getFetchParams(updateOptions);
        const sliced = this.options.sourceCollection.models.slice(
            fetchParams.offset,
            fetchParams.offset + fetchParams.limit
        );

        this.set(sliced);
        this.trigger('sync'); // Pagination is binded on that event

        return $.Deferred().resolve(sliced); // eslint-disable-line
    }
});

module.exports = ManagedTaskTypesCollection;
