/**
 * @class NotificationsCollection
 * @extends Backbone.Collection
 */
const NotificationsCollection = Backbone.Collection.extend({

    model: require('../model/NotificationModel'),

    parse(data) {
        let items = [];

        if (data) {
            if (data instanceof Array) {
                items = data;
            } else {
                // Fallback for current implementation of the API
                if (data.on_failure) {
                    items.push({
                        transport: data.transport,
                        receivers: [data.on_failure],
                        statuses: ['FAILURE']
                    });
                }

                if (data.on_success) {
                    items.push({
                        transport: data.transport,
                        receivers: [data.on_success],
                        statuses: ['SUCCESS']
                    });
                }
            }
        }

        return items;
    },

    toJSON() {
        return _.filter(this.map(notification => {
            return notification.toJSON();
        }), notification => {
            return (notification.recipients.length > 0);
        });
    }
});

module.exports = NotificationsCollection;
