const app = require('./../app');

const BasicCollection = require('./BasicCollection');
const ReleaseFilterModel = require('../model/filter/ReleaseFilterModel');

/**
 * @class ReleasesCollection
 * @extends BasicCollection
 * @extends Backbone.Events
 */
const ReleasesCollection = BasicCollection.extend({

    url: '/api/v1.0/release',
    model: require('../model/ReleaseModel'),

    initialize(models, options) {
        this.mapQueryOptions(options);

        this.setFilterParams = this.setFilterParams.bind(this);

        app.stopListening(app, 'change:filterparams:preset');
        app.listenTo(app, 'change:filterparams:preset', this.setFilterParams);
    },

    /**
     * @param {Object} updateOptions Set of options collection will be updated with.
     */
    update(updateOptions) {
        updateOptions = updateOptions || this.getPagingOptions();

        this.trigger('update:start');

        return this
            .fetch({
                data: _.extend(
                    this.getFetchParams(updateOptions),
                    this.getFilterParams().serializeAsQuery(),
                    this.getReleaseQueryProps()
                ),
                cancellable: true
            });
    },

    mapFilterQueryOptions(options) {
        this.options.filterParams = new ReleaseFilterModel(options);
    },

    getReleaseQueryProps() {
        return {
            status: 'RELEASED',
            fields: 'id,description,status,time,priority,release,owner,type'
        };
    }

});

module.exports = ReleasesCollection;
