const BasicCollection = require('./BasicCollection');

/**
 * @calss SandboxNotificationsCollection
 * @extends BasicCollection
 */
const SandboxNotificationsCollection = BasicCollection.extend({

    url: '/api/v1.0/notification',

    model: require('../model/SandboxNotificationModel'),

    initialize(models, options) {
        BasicCollection.prototype.initialize.apply(this, arguments);
        this.mapQueryOptions(options);
    },

    update(updateOptions) {
        const self = this;

        if (this.isUpdating) {
            this.isNeedUpdate = true;

            return false;
        }

        updateOptions = updateOptions || this.getPagingOptions();

        this.isUpdating = true;
        this.trigger('update:start');

        return this.fetch({
            data: _.extend(this.getFetchParams(updateOptions), this.getFilterParams().serializeAsQuery())
        })
            .always(() => {
                self.isUpdating = false;

                if (self.isNeedUpdate) {
                    self.isNeedUpdate = false;
                    self.update();
                } else {
                    self.trigger('update:complete');
                }
            });
    },

    getSelected() {
        const selected = this.findWhere({ selected: true });

        return (selected ? selected : null);
    },

    mapFilterQueryOptions(options) {
        const SandboxNotificationsFilterModel = require('../model/filter/SandboxNotificationFilterModel');

        this.options.filterParams = new SandboxNotificationsFilterModel();
        this.options.filterParams.set(SandboxNotificationsFilterModel.parseOuterFilterValues(options.filterParams));
    }
});

module.exports = SandboxNotificationsCollection;
