// eslint-disable-next-line no-unused-vars
const error = require('../error');
const BasicCollection = require('./BasicCollection');
const TasksCollection = require('./TasksCollection');
const SchedulerFilterModel = require('../model/filter/SchedulerFilterModel');

/**
 * @class SchedulersCollection
 * @extends TasksCollection
 */
const SchedulersCollection = TasksCollection.extend({

    url: '/api/v1.0/scheduler',

    model: require('../model/SchedulerModel'),

    filterModelClass: SchedulerFilterModel,

    metricKey: 'SCHEDULERS-LOADED',

    batchAction(action, schedulers) {
        schedulers = (schedulers instanceof Array ? schedulers : this.where({ selected: true }));

        return SchedulersCollection.batchAction(action, schedulers);
    }

}, {

    /**
     * @param {String}      action
     * @param {SchedulerModel[]} schedulers
     *
     * @returns {JQueryDeferred}
     */
    batchAction(action, schedulers, options) {
        return BasicCollection.batchAction(action, schedulers, _.extend({
            url: ('/api/v1.0/batch/schedulers/' + action),
            actions: SchedulersCollection.BATCH_OPERATIONS
        }, options));
    }
});

SchedulersCollection.BATCH_OPERATIONS = {
    STOP: 'stop',
    START: 'start',
    DELETE: 'delete'
};

SchedulersCollection.OPERATION_RESULT_EVENT = {
    ERROR: 'actionError',
    SUCCESS: 'actionSuccess'
};

module.exports = SchedulersCollection;
