const BasicCollection = require('./BasicCollection');
const SemaphoreFilterModel = require('../model/filter/SemaphoreFilterModel');

/**
 * @class SemaphoreCollection
 * @extends BasicCollection
 * @extends Backbone.Events
 */
const SemaphoreCollection = BasicCollection.extend({

    url: '/api/v1.0/semaphore',

    model: require('../model/SemaphoreModel'),

    initialize(models, options) {
        this.mapQueryOptions(options);

        this.listenTo(this, 'change:filterparams:preset', this.setFilterParams);
    },

    /**
     * @param {Object} updateOptions Set of options collection will be updated with.
     */
    update(updateOptions) {
        if (this.isUpdating) {
            this.isNeedUpdate = true;

            return false;
        }

        updateOptions = updateOptions || this.getPagingOptions();

        this.isUpdating = true;
        this.trigger('update:start');

        return this
            .fetch({
                data: _.extend(
                    this.getFetchParams(updateOptions),
                    this.getFilterParams().serializeAsQuery()
                )
            })
            .always(() => {
                this.isUpdating = false;

                if (this.isNeedUpdate) {
                    this.isNeedUpdate = false;
                    this.update();
                } else {
                    this.trigger('update:complete');
                }
            });
    },

    mapFilterQueryOptions(options) {
        this.options.filterParams = new SemaphoreFilterModel(options);
    },

    getFilterParams() {
        return this.options.filterParams;
    }
});

module.exports = SemaphoreCollection;
