/**
 * @class ServiceThreadCollection
 * @extends Backbone.Collection
 */
const ServiceThreadCollection = Backbone.Collection.extend({

    url: '/api/v1.0/service/status/threads',

    model: require('../model/service/ServiceThreadModel'),

    comparator: 'id',

    parse(data) {
        return _.map(data, thread => {
            /* eslint camelcase: 0 */

            return {
                id: thread.id,
                last_run: (thread.run_time ? thread.run_time.last : ''),
                next_run: (thread.run_time ? thread.run_time.next : ''),
                lock_handlers: thread.locks
            };
        });
    }

});

module.exports = ServiceThreadCollection;
