const ShardModel = require('../model/service/ShardModel');
const ShardServerModel = require('../model/service/ShardServerModel');

/**
 * @class ShardCollection
 * @extends Backbone.Collection
 *
 * @property {ShardModel} model
 */
const ShardCollection = Backbone.Collection.extend({

    url: '/api/v1.0/service/status/database/shards',

    model: ShardModel,

    parse(data) {
        this.keys = _.without(_.union.apply(null, data.map(shard => {
            return shard.replicaset.map(srv => {
                return srv.id.replace(/\.search\.yandex\.net:[0-9]+$/, '');
            });
        })), '').sort();

        return data;
    },

    getPrimary() {
        return this.findWhere({
            state: ShardServerModel.STATE.PRIMARY
        });
    }
});

module.exports = ShardCollection;
