const moment = require('moment'); // eslint-disable-line

/**
 * @class TaskHistoryItemsCollection
 * @extends Backbone.Collection
 */
const TaskHistoryItemsCollection = Backbone.Collection.extend({

    model: require('../model/TaskHistoryItemModel'),

    task: null,

    url() {
        return ('/api/v1.0/task/' + this.options.task.get('id') + '/audit');
    },

    initialize(models, options) {
        this.options = _.extend({}, this.options, options);
    },

    getLength() {
        if (this.length !== 0 && this.length !== this.options.unfetchedLength) {
            return this.length;
        }
        return this.options.unfetchedLength;
    }
});

module.exports = TaskHistoryItemsCollection;
