/**
 * @class TaskRequirementsSemaphoresCollection
 * @extends Backbone.Collection
 */
const TaskRequirementsSemaphoresCollection = Backbone.Collection.extend({

    model: require('../model/TaskRequirementsSemaphoresModel'),

    toJSON() {
        if (!this.length) {
            return null;
        }

        const data = this.reduce((result, item) => {
            result.release = result.release
                .concat(item.get('release'))
                .filter((value, index, self) => {
                    return self.indexOf(value) === index;
                });
            result.acquires.push(item.get('capacity') ? {
                name: item.get('name'),
                weight: item.get('weight') || 0,
                capacity: item.get('capacity') || 0
            } : {
                name: item.get('name'),
                weight: item.get('weight') || 0
            });

            return result;
        }, {
            release: [],
            acquires: []
        });

        if (!data.acquires.length || !data.release.length) {
            return null;
        }

        return data;
    }
});

module.exports = TaskRequirementsSemaphoresCollection;
