/**
 * @class TaskTypesCollection
 * @extends Backbone.Collection
 */
const TaskTypesCollection = Backbone.Collection.extend({

    url: '/api/v1.0/suggest/task',
    model: require('./../../model/resources/TaskTypeModel'),

    convertToList() {
        return this.map(type => {
            return type.get('type');
        });
    }
}).cache({
    ttl: 30,
    jsonOnly: true
});

module.exports = TaskTypesCollection;
