const BasicCollection = require('../BasicCollection');

const UserGroupsCollection = BasicCollection.extend({

    url() {
        return (this.options.isSuggest ? '/api/v1.0/suggest/group' : '/api/v1.0/group?limit=100500');
    },

    options: _.extend({}, BasicCollection.prototype.options, {
        isSuggest: true
    }),

    model: require('../../model/resources/UserGroupModel'),

    comparator: 'name',

    initialize(models, options) {
        this.options = _.extend({}, this.options, options);
    },

    convertToList() {
        return this.map(userGroup => {
            return userGroup.get('name');
        });
    },

    parse(data) {
        if (data.items) {
            return data.items;
        }

        return data;
    }

}).cache({
    ttl: 30,
    jsonOnly: true
});

module.exports = UserGroupsCollection;
