import React from 'react';
import PropTypes from 'prop-types';

import router from '../../router';
import i18n from '../i18n';

import SubNavigation from '../SubNavigation';

class AdminNavigation extends React.PureComponent {
    constructor(props) {
        super(props);

        this.handleMainNavigationClick = this.handleMainNavigationClick.bind(this);
        this.getUrl = this.getUrl.bind(this);
    }

    getTabs() {
        return ['groups', 'vault', 'task-types', 'semaphores'].map(item => ({
            title: i18n.admin.navigation[item],
            path: item
        }));
    }

    getUrl(activeTab) {
        const tab = this.getTabs()[activeTab];
        const url = '/admin/' + (tab ? tab.path : 'groups');

        return url;
    }

    handleMainNavigationClick(activeTab) {
        const url = this.getUrl(activeTab);

        router.navigate(url, { trigger: true });
    }

    render() {
        return (<SubNavigation
            tabs={this.getTabs()}
            active={this.props.active}
            type={'top'}
            onClick={this.handleMainNavigationClick}
            />);
    }
}

AdminNavigation.propTypes = {
    active: PropTypes.number
};

AdminNavigation.defaultProps = ({
    active: 0
});

module.exports = AdminNavigation;
