import test from 'ava';
import React from 'react';
import { mount } from 'enzyme';
import sinon from 'sinon';

import AdminNavigation from './index';

test('should be rendered with custom content', t => {
    const navigation = mount(<AdminNavigation active={0}/>);

    t.is(navigation.type(), AdminNavigation);

    const text = navigation.text();

    t.is(text.indexOf('Groups') !== -1, true);
    t.is(text.indexOf('Vault') !== -1, true);
    t.is(text.indexOf('Task types') !== -1, true);
    t.is(text.indexOf('Semaphores') !== -1, true);
});

test('should be handled correctly', t => {
    const navigate = sinon.spy();

    AdminNavigation.__Rewire__('router', {
        navigate
    });

    const navigation = mount(<AdminNavigation active={0}/>);

    t.is(navigation.type(), AdminNavigation);

    const tds = navigation.find('td[data-nav-target]');

    tds.forEach((td, i) => {
        td.simulate('click');
        t.is(navigate.callCount, i + 1);
    });
});
