/* eslint no-undef: 0 */

import React from 'react';
import createReactClass from 'create-react-class';

import backboneMixin from '../utils/react.backbone';

import ArchiveInfo from '../ArchiveInfo';
import ContainerInfo from '../ContainerInfo';
import AsideWrapper from '../AsideBlockWrapper';

const AdvancedInfo = createReactClass({
    props: {
        model: {}
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    render() {
        const model = this.props.model;

        return (
            <AsideWrapper title={'Advanced'}>
                <ArchiveInfo archiveId={model.get('tasks_archive_resource')}/>
                <ContainerInfo model={model}/>
            </AsideWrapper>
        );
    }
});

module.exports = AdvancedInfo;
