const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const TaskResourcesCollection = require('../../collection/TaskResourcesCollection');

const YSpin = require('y-components').YSpin;
const AsideItemWrapper = require('../AsideItemWrapper');

const ArchiveInfo = createReactClass({
    propTypes: {
        archiveId: propTypes.number // eslint-disable-line
    },

    getInitialState() {
        return {
            isLoading: true,
            model: false
        };
    },

    componentDidMount() {
        const archiveId = this.props.archiveId;

        if (archiveId) {
            this.collection = new TaskResourcesCollection([], { id: archiveId });
            this.collection
                .update()
                .done(() => {
                    this.setState({
                        isLoading: false,
                        model: this.collection.models && this.collection.models.length && this.collection.models[0]
                    });
                });
        } else {
            this.setState({ isLoading: false });
        }
    },

    render() {
        const isLoading = this.state.isLoading;
        const model = this.state.model;

        let content = null;

        if (isLoading) {
            content = <YSpin progress size="xxs"/>;
        } else if (!model || !model.get('id')) {
            content = <span className="icon icon_minus"/>;
        } else {
            content = (
                <a className="link id" href={'/resource/' + model.get('id') + '/view'}>
                    {
                        model && model.get('description') ?
                            (
                                <span className="link__description">
                                    {model.get('description')}<br/>({model.get('id')})
                                </span>
                            ) :
                            model.get('id')
                    }
                </a>
            );
        }

        return <AsideItemWrapper title="Task archive">{content}</AsideItemWrapper>;
    }
});

module.exports = ArchiveInfo;
