const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const AsideBlockWrapper = createReactClass({
    propTypes: {
        clean: propTypes.bool,
        title: propTypes.string.isRequired,
        children: propTypes.oneOfType([
            propTypes.object,
            propTypes.array
        ])
    },

    getDefaultProps() {
        return {
            children: null
        };
    },

    render() {
        if (this.props.clean) {
            return (
                <div>
                    <h5 className="section__side__data-title">{this.props.title}</h5>
                    {this.props.children}
                </div>
            );
        }

        return (
            <table className="data">
                <thead>
                    <tr>
                        <th className="data__h" colSpan="2">{this.props.title}</th>
                    </tr>
                </thead>
                <tbody>
                    {this.props.children}
                </tbody>
            </table>
        );
    }
});

module.exports = AsideBlockWrapper;
