const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const AsideItemWrapper = createReactClass({
    propTypes: {
        title: propTypes.string.isRequired,
        children: propTypes.oneOfType([
            propTypes.object,
            propTypes.array
        ])
    },

    render() {
        return (
            <tr>
                <td className="data__l">
                    <span className="data__l__i">{this.props.title}</span>
                </td>
                <td className="data__v">
                    <span className="data__v__i">
                        {this.props.children}
                    </span>
                </td>
            </tr>
        );
    }
});

module.exports = AsideItemWrapper;
