/* eslint react/no-danger: 0 */

const React = require('react');
const propTypes = require('prop-types');
const createReactClass = require('create-react-class');

const backboneMixin = require('../utils/react.backbone');

const AsideWrapper = require('../AsideBlockWrapper');

const ClientTagsInfo = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    render() {
        const model = this.props.model;
        const requirements = model && model.get('requirements');
        let clientTags = requirements && requirements.client_tags;

        clientTags = clientTags && clientTags.replace(/ (. )/g, '&nbsp;$1');

        return (
            <AsideWrapper title={'Client tags'} clean>
                {
                    clientTags ?
                        <span className="title_console" dangerouslySetInnerHTML={{ __html: clientTags }}/> :
                        <span className="icon icon_minus"/>
                }
            </AsideWrapper>
        );
    }
});

module.exports = ClientTagsInfo;
