import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import b_ from 'b_';

import { YModal, YButton } from 'y-components';

import i18n from '../i18n';

export class Confirm extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            modalVisible: false
        };

        this._block = b_.with('confirm');
        this._texts = i18n.common;

        this.refModalTarget = ref => {
            this._modal = ref;
        };

        this.handleShowModal = this.handleShowModal.bind(this);
        this.handleHideModal = this.handleHideModal.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleShowModal() {
        this.setState({
            modalVisible: true
        });
    }

    handleHideModal() {
        this.setState({
            modalVisible: false
        });
    }

    handleSubmit() {
        const { id } = this.props;

        this.props.onSubmit(id);

        this.handleHideModal();
    }

    render() {
        const { children, mix, title, submitLabel, cancelLabel } = this.props;
        const { modalVisible } = this.state;

        return (
            <div className={`${mix} ${this._block()}`}>
                <div
                    ref={this.refModalTarget}
                    className={this._block('handler')}
                    onClick={this.handleShowModal}
                    >
                    {title}
                </div>
                <YModal
                    mix={this._block('modal')}
                    visible={modalVisible}
                    onShouldClose={this.handleHideModal}
                    >
                    <div className={this._block('content')}>
                        {children}
                    </div>
                    <YButton size="s" theme="action" onClick={this.handleSubmit}>
                        {submitLabel || this._texts.submit}
                    </YButton>
                    <YButton size="s" onClick={this.handleHideModal}>
                        {cancelLabel || this._texts.cancel}
                    </YButton>
                </YModal>
            </div>
        );
    }
}

Confirm.propTypes = {
    id: PropTypes.oneOfType(
        PropTypes.number,
        PropTypes.string
    ),
    children: PropTypes.any,
    mix: PropTypes.string,
    title: PropTypes.any,
    onSubmit: PropTypes.func,
    submitLabel: PropTypes.string,
    cancelLabel: PropTypes.string
};

Confirm.defaultProps = {
    mix: '',
    onSubmit: () => {}
};

module.exports = Confirm;
