const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');

const TaskResourcesCollection = require('../../collection/TaskResourcesCollection');

const YSpin = require('y-components').YSpin;
const AsideItemWrapper = require('../AsideItemWrapper');

const ContainerInfo = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    getInitialState() {
        return {
            isLoading: true,
            model: false
        };
    },

    getContainerId() {
        const model = this.props.model;
        let customFields = model && model.get('custom_fields');

        customFields = customFields && customFields.toJSON ? customFields.toJSON() : customFields || [];
        const containerInfo = customFields.filter(field => {
            return field.type === 'container';
        });

        return containerInfo && containerInfo.length && containerInfo[0] && containerInfo[0].value;
    },

    componentDidMount() {
        const id = this.getContainerId();

        if (id) {
            this.collection = new TaskResourcesCollection([], { id });
            this.collection
                .update()
                .done(() => {
                    this.setState({
                        isLoading: false,
                        model: this.collection.models && this.collection.models.length && this.collection.models[0]
                    });
                });
        } else {
            this.setState({ isLoading: false });
        }
    },

    render() {
        const isLoading = this.state.isLoading;
        const model = this.state.model;

        let content = null;

        if (isLoading) {
            content = <YSpin progress size="xxs" />;
        } else if (!model || !model.get('id')) {
            content = <span className="icon icon_minus" />;
        } else {
            content = (
                <a className="link id" href={'/resource/' + model.get('id') + '/view'}>
                    {
                        model && model.get('description') ?
                            (
                                <span className="link__description">
                                    {model.get('description')}<br />({model.get('id')})
                                </span>
                            ) :
                            model.get('id')
                    }
                </a>
            );
        }

        return <AsideItemWrapper title="Container">{content}</AsideItemWrapper>;
    }
});

module.exports = ContainerInfo;
