import React from 'react';
import styled from 'styled-components';
import PropTypes from 'prop-types';

import Link from '../Link';

const Item = styled.span`
    margin-right: 5px;

    > .link {
        &::first-letter {
            color: #e00;
        }

        color: #000;
    }
`;

class GroupLogin extends React.PureComponent {
    render() {
        let groups = [];

        if (this.props.groups) {
            if (this.props.groups instanceof Array) {
                groups = this.props.groups;
            } else {
                groups.push(this.props.groups);
            }
        }

        return groups.length ?
            (<span>
                {
                    groups.map(group => (<Item key={group}>
                        {
                            this.props.isLink ?
                                <Link to={`/admin/groups/${group}`}>{group}</Link> :
                                group
                        }
                    </Item>))
                }
            </span>) :
            null;
    }
}

GroupLogin.propTypes = {
    groups: PropTypes.array,
    isLink: PropTypes.bool
};

module.exports = GroupLogin;
