/* eslint react/forbid-component-props: 0 */
/* eslint max-len: 0 */

import React from 'react';
import styled from 'styled-components';
import PropTypes from 'prop-types';

import { YInput } from 'y-components';

const Table = styled.table`
    width: 100%;
`;

const Td = styled.td`
    padding-right: 10px;

    .y-button-group {
        padding: 0 5px;
    }

    ${props => {
        if (props.right) {
            return `
                .y-button-group {
                    float: right;
                }
            `;
        }

        if (props.short) {
            return `
                width: 80px;
                .y-button-group {
                    padding: 0;
                }  
            `;
        }

        if (props.fixed) {
            return `
                max-width: 330px;
                .y-input {
                    max-width: 330px;
                    padding: 0;
                }  
            `;
        }
    }}
`;

class Filter extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            name: ''
        };

        this.handleChange = this.handleChange.bind(this);
        this.handleApply = this.handleApply.bind(this);
    }

    handleChange(e) {
        const value = e.target.value.toUpperCase();

        if (this.state[e.target.name] !== value) {
            this.setState({ [e.target.name]: value }, () => {
                if (value.length > 1 || !value.length) {
                    this.handleApply();
                }
            });
        }
    }

    handleApply() {
        this.props.onFilterChange(this.state);
    }

    render() {
        return (<Table>
            <tbody>
                <tr>
                    <Td fixed>
                        <YInput
                            size="s"
                            placeholder="Name"
                            name="name"
                            onChange={this.handleChange}
                            value={this.state.name}
                            />
                    </Td>
                </tr>
            </tbody>
        </Table>);
    }
}

Filter.propTypes = {
    onFilterChange: PropTypes.func
};

module.exports = Filter;
