import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import Edit from '../Edit';
import Filter from '../Filter';

const Wrapper = styled.div`
    position: relative;
    background: #fafaf9;
    padding: 15px 20px;
    border-top: 1px solid #e5e5e5;
`;

class Headding extends PureComponent {
    constructor(props) {
        super(props);

        this.handleFilterChange = this.handleFilterChange.bind(this);
    }

    handleFilterChange(data) {
        this.props.onFilterChange(data);
    }

    render() {
        return (<Wrapper>
            <Edit/>
            <Filter onFilterChange={this.handleFilterChange}/>
        </Wrapper>);
    }
}

Headding.propTypes = {
    onFilterChange: PropTypes.func
};

Headding.defaultProps = {
    onFilterChange() {}
};

module.exports = Headding;
