import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import i18n from '../../../../i18n';

import Confirm from '../../../../Confirm';
import Edit from '../../../Edit';

const Name = styled.div`
    font-family: 'Ubuntu Mono', 'PT Mono', Consolas, monospace;
    margin: 10px 0;
`;

const ControlsWrap = styled.div`
    display: inline-block;
`;

class SemaphoresItemControls extends PureComponent {
    constructor() {
        super(...arguments);

        this.handleSubmitRemoving = this.handleSubmitRemoving.bind(this);
    }

    handleSubmitRemoving(name) {
        this.props.onSubmitRemoving(name);
    }

    render() {
        const { data, onPush, editLabel, removeLabel } = this.props;

        if (data && data.rights === 'write') {
            return (<ControlsWrap>
                <Edit
                    label={editLabel}
                    onPush={onPush}
                    name={data.name}
                    />

                <Confirm
                    title={removeLabel}
                    submitLabel={i18n.common.remove}
                    id={data.name}
                    mix={'confirm__inline'}
                    onSubmit={this.handleSubmitRemoving}
                    >
                    <h3>{i18n.questions.removeGroup}</h3>
                    <Name>{data.name}</Name>
                </Confirm>
            </ControlsWrap>);
        }

        return null;
    }
}

SemaphoresItemControls.propTypes = {
    data: PropTypes.object,
    onSubmitRemoving: PropTypes.func,
    onPush: PropTypes.func,
    editLabel: PropTypes.object,
    removeLabel: PropTypes.object
};

SemaphoresItemControls.defaultProps = {
    data: {},
    onPush: () => {},
    editLabel: (
        <button className="button button_size_S button_type_clear button_icon-only_yes">
            <span
                className="button__icon"
                style={{
                    backgroundImage: `url(${baseUrl}/images/icons/pencil-icon.svg)`,
                    backgroundSize: '16px'
                }}
                title="Edit"
                />
        </button>
    ),
    removeLabel: (
        <button className="button button_size_S button_type_clear button_icon-only_yes">
            <span
                className="button__icon"
                style={{
                    backgroundImage: `url(${baseUrl}/images/icons/x-mark-icon.svg)`,
                    backgroundSize: '16px'
                }}
                title="Remove"
                />
        </button>
    )
};

module.exports = SemaphoresItemControls;
