/* eslint complexity: [1, 22] */

import React from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

const TextWrap = styled('div')`
    width: 100%;
    height: ${props => props.slim ? '7px' : '20px'};
    border-radius: 3px;
    background-color: #f6f5f3;
    line-height: 20px;
    border: 1px solid #dddcda;
    overflow: hidden;
    box-sizing: border-box;
`;

const Text = styled('div')`
    font-size: 12px;
    padding: 0 10px;
    box-sizing: border-box;
    position: relative;
    height: 20px;
    line-height: 18px;
    margin-bottom: -20px;
    text-align: center;
    color: ${props => props.offset >= 65 ? '#fff' : '#000'};
`;

const Stack = styled('div')`
    height: ${props => props.slim ? '7px' : '20px'};
    line-height: 20px;
    overflow: hidden;
    display: inline-block;
    background: ${props => {
        if (props.future) {
            return '#ccc';
        }

        if (props.weight < 100) {
            return '#8cc152';
        }

        return '#f70000';
    }};
    width: ${props => props.offset}%
`;

const Popup = styled('div')`
    position: absolute;
    z-index: 99;
    visibility: visible;
    margin-top: 0;
    background: #fff;
    transition: opacity .4s ease-out, margin .4s ease-out, visibility 0s;
    padding: 10px;
    margin: 5px 20px;
    border: 1px solid #f6f5f3;
    visibility: hidden;
    opacity: 0;
    font-size: 13px;
    line-height: 18px;

    ${props => props.float === 'right' ? 'right: 0;' : 'left: 0;'}
`;

const Wrap = styled('div')`
    padding: 0 0 7px;

    &:hover ${Popup}{
        visibility: visible;
        opacity: 1;
    }

    ${props => props.bounded === true ? '' : 'margin-bottom: -7px;'}
`;

const Minus = () => <span className="icon icon_minus"/>;

const Label = styled('div')`
    padding: 5px 0;

    a {
        text-decoration: none;
        color: #000;

        &:first-letter {
            color: #f70000;
        }
    }
`;

const Title = styled('span')`
    width: 230px;
    overflow: hidden;
    display: inline-block;
    position: relative;
    vertical-align: top;

    span:nth-child(1) {
        width: 100px;
    }

    &:after {
        content: ".........................................................................................................................................................................................................................................................................................................................................................";
        margin-left: -7px;
        position: absolute;
        color: #777;
    }
`;

const Value = styled('span')``;

const getLabel = label => label === null ? <Minus/> : label;
const getConsumptionValue = value => value === null ? 0 : value;

class Progress extends React.PureComponent {
    render() {
        const { quota, float, slim, name, namespace } = this.props;

        const consumption = quota.consumption;
        const limit = quota.limit;

        let realPersentage = null;
        let futurePersentage = null;
        let totalPersentage = null;
        let widthRealPersentage = 0;
        let widthFuturePersentage = 0;

        if (consumption) {
            if (consumption.real !== undefined || consumption.future !== undefined) {
                const real = (getConsumptionValue(consumption.real));
                const future = (getConsumptionValue(consumption.future));
                const parsedLimit = (getConsumptionValue(limit));

                if ((real && future && parsedLimit) || consumption.real === 0 || consumption.future === 0) {
                    realPersentage = Math.round(real / parsedLimit * 100);
                    futurePersentage = Math.round(future / parsedLimit * 100);
                    totalPersentage = realPersentage + futurePersentage;

                    if (real + future > limit) {
                        widthRealPersentage = 100;
                        widthFuturePersentage = 0;
                    } else {
                        widthRealPersentage = realPersentage;
                        widthFuturePersentage = futurePersentage;
                    }
                }
            } else {
                realPersentage = Math.round((getConsumptionValue(consumption) / getConsumptionValue(limit)) * 100);
                totalPersentage = realPersentage;

                widthRealPersentage = realPersentage;
            }
        }

        const shouldShowLink = Boolean(name && namespace);

        return (
            <Wrap bounded={shouldShowLink}>
                <TextWrap slim={slim}>
                    {
                        !slim && <Text offset={totalPersentage}>
                            {
                                totalPersentage === null ?
                                    <Minus/> :
                                    `${totalPersentage}%`
                            }
                        </Text>
                    }
                    <Stack
                        real
                        weight={totalPersentage || realPersentage}
                        offset={widthRealPersentage}
                        slim={slim}
                        />
                    <Stack
                        future
                        weight={futurePersentage || 0}
                        offset={widthFuturePersentage}
                        slim={slim}
                        />
                </TextWrap>
                <Popup float={float}>
                    {
                        shouldShowLink && <Label>
                            <a href={`/${namespace}?page=1&pageCapacity=20&order=-updated&owner=${name}`}>{name}</a>
                        </Label>
                    }
                    <Label>
                        <Title>Consumption (real + future) / Quota</Title>
                        <Value>
                            {
                                consumption && (consumption.real === null || consumption.future === null) ?
                                    getLabel(null) :
                                    consumption && consumption.real !== null ?
                                        `${getLabel(Math.round((getConsumptionValue(consumption.real) / 1000)))} + ${getLabel(Math.round(getConsumptionValue(consumption.future) / 1000))}` :
                                        getLabel(Math.round(consumption / 1000))
                            } / {
                                limit === null ?
                                    getLabel(null) :
                                    getLabel(Math.round(getConsumptionValue(limit) / 1000))
                            }
                        </Value>
                    </Label>
                    <Label>
                        <Title>Position in rating</Title>
                        <Value>{getLabel(quota.rating.index)} / {getLabel(quota.rating.total)}</Value>
                    </Label>
                    <Label>
                        <Title>Tasks in queue</Title>
                        <Value>{getLabel(quota.rating.queue_size)}</Value>
                    </Label>
                    <Label>
                        <Title>Executing jobs</Title>
                        <Value>{getLabel(quota.rating.executing_jobs)}</Value>
                    </Label>
                </Popup>
            </Wrap>
        );
    }
}

Progress.propTypes = {
    quota: PropTypes.object,
    float: PropTypes.string,
    slim: PropTypes.bool,
    name: PropTypes.string,
    namespace: PropTypes.string
};

export default Progress;
