/* eslint react/forbid-component-props: 0 */

import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';
import cookie from 'bemmy/src/blocks/component/cookie';

import Link from '../../../Link';
import UserLogin from '../../../UserLogin';
import Controls from './Controls';
import Progress from './Progress';
import clipboardClientMixin from '../../../../views/components/clipboardClient/ClipboardClientMixin';

import { Name, Members, Email, State, Group, Edit, Quota } from '../../List';

const Wrapper = styled.div`
    display: inline-table;
    width: 100%;
    padding: 7px 20px;
    box-shadow: inset 0 1px 0 #EBEBEB;
    background: #fff;
    box-sizing: border-box;
    table-layout: fixed;

    :hover {
        background: #e5f4fe;

        .id-proxy-copier {
            opacity: 1;
        }
    }

    > div {
        display: table-cell;
    }

    ${props => props.isDeleting && 'opacity: 0.3'}
`;

const Icon = styled.span`
    margin-left: 5px;
    opacity: 0;
    transition: opacity .1s ease;
`;

const Admin = styled.span`
    float: right;
    line-height: 18px;
`;

class Item extends PureComponent {
    constructor(props) {
        super(props);

        this.login = cookie.getYandexLogin();
    }

    componentDidMount() {
        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'Name has been copied to clipboard.'
        );
    }

    render() {
        const { name, members, email, sources, onRemove, isDeleting, level, quota } = this.props;

        return (<Wrapper isDeleting={isDeleting}>
            <Quota><Progress quota={quota}/></Quota>
            <Name level={level}>
                { this.login && members.indexOf(this.login) !== -1 && <Admin className="fa fa-star"/> }
                <Link to={`/admin/groups/${name}`}>{name}</Link>
                <Icon
                    className="link external fa fa-files-o id-proxy-copier"
                    data-clipboard-text={name}
                    />
            </Name>
            <Members>{members.map((member, i) => <UserLogin key={i} login={member}/>)}</Members>
            <State>{sources ? sources.map(source => source.source).join(', ') : ''}</State>
            <Group>{sources && sources.map(source => source.group ? source.group.split(',').map(item => item.trim()).map((item, i) => {
                if (source.source === 'USER') {
                    return <UserLogin key={i} login={item}/>;
                }
                if (source.source === 'STAFF' || item[0] === '@') {
                    if (item.indexOf('yandex_') === 0) {
                        return <a className="link external" key={i} href={`https://staff.yandex-team.ru/departments/${item}`}>{item}</a>;
                    }

                    return <UserLogin key={i} login={item[0] === '@' ? item.slice(1) : item}/>;
                }
                if (source.source === 'ABC') {
                    return <a className="link external" key={i} href={`https://abc.yandex-team.ru/services/${item}`}>{item}</a>;
                }
                return <span key={i}>{item}</span>;
            }) : null)}</Group>
            <Email><Link to={`mailto:${email}@yandex-team.ru`}>{email}</Link></Email>
            <Edit>{!isDeleting && <Controls data={this.props} onSubmitRemoving={onRemove}/>}</Edit>
        </Wrapper>);
    }
}

Item.propTypes = {
    quota: PropTypes.object,
    name: PropTypes.string,
    sources: PropTypes.array,
    members: PropTypes.arrayOf(PropTypes.string),
    email: PropTypes.string,
    level: PropTypes.number,
    isDeleting: PropTypes.bool,
    onRemove: PropTypes.func
};

module.exports = Item;
