/* eslint react/jsx-indent-props: 0 */

import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';
import cookie from 'bemmy/src/blocks/component/cookie';

import { YSpin } from 'y-components';

import Splash from '../../Splash';

import Item from './Item';

const Wrapper = styled.div`
    display: inline-table;
    width: 100%;
    padding: 7px 20px;
    box-shadow: inset 0 1px 0 #EBEBEB;
    background: #eee;
    box-sizing: border-box;
    font-weight: 700;

    > div {
        display: table-cell;
    }
`;

export const Quota = styled.div`
    vertical-align: middle;
    width: 5%;
    padding: 0 5px 0 0;
`;

export const Name = styled.div`
    width: 14%;
    word-break: break-word;
    vertical-align: middle;
    padding: 0 5px;

    > .link {
        display: inline;
    }
`;

export const Members = styled.div`
    width: 47%;
    min-width: 50px;
    vertical-align: middle;
    padding: 0 5px;
`;

export const Email = styled.div`
    width: 12%;
    word-break: break-all;
    vertical-align: middle;
    padding: 0 5px;
`;

export const State = styled.div`
    width: 5%;
    vertical-align: middle;
    min-width: 70px;
    padding: 0 5px;
`;

export const Group = styled.div`
    width: 13%;
    word-break: break-word;
    vertical-align: middle;
    padding: 0 5px;

    a, span {
        margin-right: 5px;
    }
`;

export const Edit = styled.div`
    width: 3%;
    white-space: nowrap;
    vertical-align: middle;
    text-align: right;
`;

const SpinWrap = styled.div`
    min-height: 35px;

    .y-spin {
        margin: 10px 20px;
    }
`;

const Relative = styled.div`
    position: relative;
`;

class List extends PureComponent {
    constructor(props) {
        super(props);

        this.renderList = this.renderList.bind(this);
        this.login = cookie.getYandexLogin();
    }

    renderList() {
        const sortingFunction = (a, b) => {
            if (a.name < b.name) {
                return -1;
            }
            if (a.name > b.name) {
                return 1;
            }
            return 0;
        };
        const { items } = this.props;
        const mineItems = items
            .filter(item => this.login && item.members.indexOf(this.login) !== -1)
            .sort(sortingFunction);
        const otherItems = items
            .filter(item => !this.login || item.members.indexOf(this.login) === -1)
            .sort(sortingFunction);
        const result = [];

        mineItems.forEach((item, i) => result.push(<Item key={i + item.name} {...item} onRemove={this.props.onRemove}/>));
        otherItems.forEach((item, i) => result.push(<Item key={i + item.name} {...item} onRemove={this.props.onRemove}/>));

        return result;
    }

    render() {
        const { isLoading } = this.props;

        return (
            <Relative>
                { isLoading ? <Splash/> : null }
                <Wrapper>
                    <Quota>Quota</Quota>
                    <Name>Group name</Name>
                    <Members>Members</Members>
                    <State>Source</State>
                    <Group>Sync group</Group>
                    <Email>Email</Email>
                    <Edit><div/></Edit>
                </Wrapper>
                <div>
                    {
                        isLoading ?
                            <SpinWrap><YSpin progress size={'xs'}/></SpinWrap> :
                            this.renderList()
                    }
                </div>
            </Relative>
        );
    }
}

List.propTypes = {
    onRemove: PropTypes.func,
    items: PropTypes.array,
    isLoading: PropTypes.bool
};

List.defaultProps = {
    onRemove: () => {},
    isLoading: false
};

export default List;
