import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { get } from 'lodash';

import API from '../../api';

import AdminNavigation from '../AdminNavigation';
import Headding from './Headding';
import List from './List';

class GroupsManager extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            items: props.items
        };

        this.handleFilterChange = this.handleFilterChange.bind(this);
    }

    componentWillReceiveProps(newProps) {
        this.setState({
            items: newProps.items
        });
    }

    componentDidMount() {
        this.props.fetchGroupsList();
    }

    handleFilterChange(data) {
        const { items } = this.props;

        if (!data.name) {
            this.setState({
                items
            });

            return;
        }

        this.setState({
            items: (items || []).filter(item => {
                let isOk = true;

                if (data.name && item.name) {
                    isOk = isOk && item.name.indexOf(data.name) !== -1;
                }

                return isOk;
            })
        });
    }

    render() {
        const isLoading = this.props.items.length === 0;
        const { items } = this.state;

        return (<div>
            <AdminNavigation active={0}/>
            <Headding onFilterChange={this.handleFilterChange}/>
            <List items={items} isLoading={isLoading} onRemove={this.props.handleRemove}/>
        </div>);
    }
}

GroupsManager.propTypes = {
    items: PropTypes.array,
    handleRemove: PropTypes.func,
    fetchGroupsList: PropTypes.func
};

function mapStateToProps(state) {
    return {
        items: get(state, ['groups', 'items'], [])
    };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchGroupsList: () => dispatch(API.groups.fetchGroupsList()),
        handleRemove: name => dispatch(API.groups.removeGroup({ name }))
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(GroupsManager);
