const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../../utils/react.backbone');

const YPopup = require('y-components').YPopup;
const Label = require('../../StatusLabel');

const HostsInfoHost = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    getInitialState() {
        return {
            target: '',
            popupVisible: false
        };
    },

    componentDidMount() {
        this.setState({
            target: this._target
        });
    },

    refTarget(ref) {
        this._target = ref;
    },

    handleTogglePopup() {
        this.setState({
            popupVisible: !this.state.popupVisible
        });
    },

    handleShouldClose() {
        this.setState({
            popupVisible: false
        });
    },

    render() {
        const model = this.props.model;
        const tags = model.get('tags');

        return (
            <span>
                <span
                    className="host-info__title"
                    ref={this.refTarget}
                    onClick={this.handleTogglePopup}
                >
                    {model.get('id')}
                </span>
                <YPopup
                    mix="host-info__popup"
                    directions={['bottom-right']}
                    visible={this.state.popupVisible}
                    target={this.state.target}
                    onShouldClose={this.handleShouldClose}
                >
                    {tags.length ?
                        tags.map((item, i) => <Label status={item} key={i} />) :
                        'No tags'
                    }
                </YPopup>
            </span>
        );
    }
});

module.exports = HostsInfoHost;
