const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const HostsInfoLine = createReactClass({
    propTypes: {
        data: propTypes.array,
        isTitle: propTypes.bool
    },

    getDefaultProps() {
        return {
            data: [],
            isTitle: false
        };
    },

    render() {
        const data = this.props.data;
        const isTitle = this.props.isTitle;

        if (!data.length) {
            return null;
        }

        if (isTitle) {
            return (<tr>
                {
                    data.map((item, i) =>
                        <th className="data__h" key={i}>
                            {
                                item ?
                                    <span>{item}</span> :
                                    <span className="icon icon_minus"/>
                            }
                        </th>)
                }
            </tr>);
        }

        const first = data.shift();

        return (
            <tr>
                {
                    <td className="data__l">
                        {
                            first ?
                                <span className="data__l__i">{first}</span> :
                                <span className="icon icon_minus"/>
                        }
                    </td>
                }
                {
                    data.map((item, i) => (
                        <td key={i} className="data__v">
                            {
                                item ?
                                    <span className="data__v__i">{item}</span> :
                                    <span className="icon icon_minus"/>
                            }
                        </td>))
                }
            </tr>
        );
    }
});

module.exports = HostsInfoLine;
