const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');
const format = require('../utils/format');

const Line = require('./Line');
const Host = require('./Host');

const HostsInfo = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    getInitialState() {
        return {
            model: this.props.model.clone()
        };
    },

    componentDidMount() {
        const model = this.state.model;
        const execInfo = model && model.get('execution');

        if (execInfo && execInfo.client && execInfo.client.id) {
            if (model) {
                model.fetchClient().done(() => {
                    this.setState({ model });
                });
            }
        }
    },

    render() {
        /* eslint complexity: [1,6] */
        /* eslint react/jsx-key: 0  */
        const model = this.state.model;
        const requirements = model.get('requirements') || {};
        const client = (model.get('client') && model.get('client').toJSON()) || {};

        const data = client.id ?
            [
                ['hosts', 'req.', 'real'],
                ['Host', requirements.host, <Host model={model.get('client')}/>],
                ['Platform', requirements.platform, (client.os || {}).name],
                ['CPU', requirements.cpu_model, client.cpu],
                ['nCPU', ' ', client.ncpu],
                ['RAM', format(requirements.ram, '0.00 b'), format(client.ram, '0.00 b')]
            ] :
            [
                ['hosts', 'req.'],
                ['Host', requirements.host],
                ['Platform', requirements.platform],
                ['CPU', requirements.cpu_model],
                ['DISK', format(requirements.disk_space, '0.00 b')],
                ['RAM', format(requirements.ram, '0.00 b')]
            ];

        return (
            <table className="data">
                <thead>
                    <Line data={data[0]} isTitle/>
                </thead>
                <tbody>
                    {
                        data.map((item, i) => i !== 0 && <Line data={item} key={i}/>)
                    }
                </tbody>
            </table>
        );
    }
});

module.exports = HostsInfo;
