import React from 'react';
import router from '../../router';
import PropTypes from 'prop-types';

class Link extends React.PureComponent {
    constructor() {
        super(...arguments);

        this.handleOnClick = this.handleOnClick.bind(this);
    }

    handleOnClick(e) {
        const href = e.target.getAttribute('href');

        if (href && href !== '#') {
            router.navigate(href, { trigger: true });
        }

        if (this.props.onClickHandler) {
            this.props.onClickHandler(href);
        }
    }

    render() {
        return (<a
            href={this.props.to}
            target={this.props.target}
            className="link"
            onClick={this.handleOnClick}
            >
            {this.props.children}
        </a>);
    }
}

Link.propTypes = {
    onClickHandler: PropTypes.func,
    to: PropTypes.string,
    target: PropTypes.string,
    children: PropTypes.any
};

module.exports = Link;
