import test from 'ava';
import React from 'react';
import sinon from 'sinon';
import { shallow, mount } from 'enzyme';

import Link from './index';

test('should render component with custom children', t => {
    const wrapper = shallow(<Link>link text</Link>);

    t.is(wrapper.type(), 'a');
    t.is(wrapper.text(), 'link text');
});

test('should render component with custom link', t => {
    const wrapper = shallow(<Link to={'https://ya.ru'}>link text</Link>);

    t.is(wrapper.getNode().props.href, 'https://ya.ru');
});

test('should render component with custom target', t => {
    const wrapper = shallow(<Link to={'https://ya.ru'} target={'_blank'}>link text</Link>);

    t.is(wrapper.getNode().props.target, '_blank');
});

test('should simulate navigation events', t => {
    const navigate = sinon.spy();

    Link.__Rewire__('router', {
        navigate
    });

    const wrapper = mount(<Link
        to={'https://ya.ru'}
        target={'_blank'}
        >
            link text
    </Link>);

    wrapper.find('a').simulate('click');

    t.is(navigate.calledOnce, true);
    sinon.assert.calledWithExactly(navigate, 'https://ya.ru', { trigger: true });
});

test('should not simulate navigation events with hash or blank href', t => {
    const navigate = sinon.spy();

    Link.__Rewire__('router', {
        navigate
    });

    let wrapper = mount(<Link
        to={''}
        target={'_blank'}
        >
            link text
    </Link>);

    wrapper.find('a').simulate('click');

    wrapper = mount(<Link
        to={'#'}
        target={'_blank'}
        >
            link text
    </Link>);

    wrapper.find('a').simulate('click');

    t.is(navigate.callCount, 0);
});

test('should simulate onClickHandler events', t => {
    const handleClick = sinon.spy();
    const wrapper = mount(<Link
        to={'https://ya.ru'}
        target={'_blank'}
        onClickHandler={handleClick}
        >
            link text
    </Link>);

    wrapper.find('a').simulate('click');
    t.is(handleClick.calledOnce, true);
});
