const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');

const YSpin = require('y-components').YSpin;

const LinkToCode = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired, // eslint-disable-line
        revision: propTypes.number
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    getCorePath() {
        return 'https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/';
    },

    getLink(relativePath, revision) {
        return this.getCorePath() + relativePath + (revision ? ('?peg=' + revision) : '');
    },

    getLinks() {
        const model = this.props.model;
        const revision = this.props.revision;
        const data = model.get('data') || [];

        return data.map((item, i) => {
            return item && item.relative_path ?
                <a
                    className="link"
                    style={{ textDecoration: 'underline' }}
                    key={i}
                    href={this.getLink(item.relative_path, revision)}
                    target="_blank"
                    rel="noopener noreferrer"
                >show source</a> :
                null;
        }) || null;
    },

    render() {
        const model = this.props.model;
        const isLoading = model && !model.get('data');
        const hasError = model && model.get('hasError');

        if (hasError) {
            return null;
        }

        let content = null;

        if (isLoading) {
            content = <YSpin progress size="xxs" />;
        } else {
            content = this.getLinks();
        }

        return <span>{content}</span>;
    }

});

module.exports = LinkToCode;
