import React, { Component } from 'react';
import axios from 'axios';
import b_ from 'b_';

const block_ = b_.with('btn-new-ui');

import { YButton } from 'y-components';

class LinkToNewUI extends Component {
    constructor(props) {
        super(props);

        this.handleClick = this.handleClick.bind(this);
    }

    handleClick(e) {
        e.preventDefault();
        e.stopPropagation();

        const url = '/api/v1.0/user/current/preferences/prefs';

        axios
            .get(url)
            .then(function (response) {
                if (response && response.data) {
                    const data = Object.assign({}, response.data, { interface: 'new' });

                    axios
                        .put(url, data)
                        .then(function () {
                            window.location.reload();
                        });
                }
            })
            .catch(function () {
                const data = { interface: 'new' };

                axios
                    .put(url, data)
                    .then(function () {
                        window.location.reload();
                    });
            });
    }

    render() {
        return (
            <a
                href={'#'}
                className={block_()}
                onClick={this.handleClick}
            >
                <YButton size={'xs'}>Go to new interface</YButton>
            </a>
        );
    }
}

module.exports = LinkToNewUI;
