/* eslint camelcase: 0 */

const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');

const ButtonGroup = require('y-components').YButtonGroup;
const Button = require('y-components').YButton;
const Checkbox = require('y-components').YCheckbox;

const TabContentWrapper = require('../TabContentWrapper');
const LogsTail = require('../LogsTail');

const LogsTab = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    getInitialState() {
        return {
            type: 'common',
            scroll: true
        };
    },

    handleRadioChange(e, { value, name }) {
        const values = this.state[name];
        const index = values.indexOf(value);

        if (index !== -1) {
            return;
        }

        this.setState({ [name]: value });
    },

    handleScrollChange(e) {
        this.setState({
            [e.target.name]: e.target.checked
        });
    },

    render() {
        const taskModel = this.props.model.get('task');
        const logs = taskModel && taskModel.get('logs');
        const files = _.where(logs, { node_type: 'file', name: this.state.type + '.log' });

        const ScrollControl = (<Checkbox
            size="s"
            mix="checkbox__scroll"
            checked={this.state.scroll}
            name="scroll"
            onChange={this.handleScrollChange}
            value="true"
            >
            Autoscroll
        </Checkbox>);

        return (
            <TabContentWrapper>
                <div>
                    <ButtonGroup theme="normal" size="s" values={[this.state.type]} onChange={this.handleRadioChange}>
                        <Button name="type" value="common">Common.log</Button>
                        <Button name="type" value="debug">Debug.log</Button>
                    </ButtonGroup>
                    {ScrollControl}
                    {
                        files ?
                            (<div className="logs-tab__links">
                                {
                                    files.map((file, i) => {
                                        return (
                                            <a
                                                key={i}
                                                href={file.url}
                                                target="_blank"
                                                rel="noopener noreferrer"
                                                className="link link_dt"
                                                >
                                                open {file.name}
                                            </a>
                                        );
                                    })
                                }
                            </div>) :
                            null
                    }
                </div>
                <LogsTail
                    id={this.props.model.get('id')}
                    type={this.state.type}
                    scroll={this.state.scroll}
                    />
                {ScrollControl}
            </TabContentWrapper>
        );
    }
});

module.exports = LogsTab;
