const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');

const StatusGroup = require('../StatusGroup');
const AsideWrapper = require('../AsideBlockWrapper');

const NotificationInfo = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    render() {
        const model = this.props.model;
        const notifications = model && model.get('notifications') && model.get('notifications').toJSON();

        if (!notifications.length) {
            return (
                <AsideWrapper title={'Notification parameters'} clean>
                    <div className="section__side__group">
                        NO DATA
                    </div>
                </AsideWrapper>
            );
        }

        return (
            <AsideWrapper title={'Notification parameters'} clean>
                {
                    notifications.map((notification, i) => {
                        return (
                            <StatusGroup
                                key={i}
                                statuses={notification.statuses}
                                notifications={{
                                    transport: notification.transport,
                                    recipients: notification.recipients
                                }}
                                />
                        );
                    })
                }
            </AsideWrapper>
        );
    }
});

module.exports = NotificationInfo;
